/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.application.googleanalytics;

import com.inet.application.googleanalytics.structure.GoogleAnalyticsStructureProvider;
import com.inet.classloader.I18nMessages;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner.CombinedFile;
import com.inet.plugin.HelpProviderContainer;
import com.inet.plugin.PluginInfo;
import com.inet.plugin.ServerPlugin;
import com.inet.plugin.ServerPluginManager;
import com.inet.remote.gui.RemoteGuiServerPlugin;
import com.inet.theme.server.ThemeResource;

/**
 * Plugin to add a GA tracking script to the remite interface. Has to be configured with the GA-TrackingID
 */
@PluginInfo( id = "application.gooogleanalytics", //
version = "25.10.219", //
flags = "core",
dependencies = "remotegui",
optionalDependencies = "theme",
packages = "", //
icon = "com/inet/application/googleanalytics/client/analytics_48.png", //
group = "samples" //
)
public class GoogleAnalyticsServerPlugin implements ServerPlugin {

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerHelp( HelpProviderContainer container ) {

        // Registering extension in help, so the HelpCenter can also be tracked.
        ServerPluginManager spm = ServerPluginManager.getInstance();

        // register optional additional java script
        CombinedFile combinedFile = new CombinedFile( "application/x-javascript; charset=utf-8" );

        // add at least one javascript resource
        combinedFile.add( getClass(), "client/js/jquery.cookiebar.js" );
        combinedFile.add( getClass(), "client/js/googleanalytics.js" );
        combinedFile.addRuntimeData( new GoogleAnalyticsRuntimeData() );
        combinedFile.addMessages( new I18nMessages( "com.inet.application.googleanalytics.client.i18n.Language", GoogleAnalyticsServerPlugin.class ) );
        spm.register( CombinedFileDescription.class, new CombinedFileDescription( RemoteGuiServerPlugin.APP_KEY, 20000, "remotegui.lib.js", combinedFile ) );

        spm.register( ConfigStructureProvider.class, new GoogleAnalyticsStructureProvider() );

        CombinedFile defaultCss = new CombinedFile( "text/css" );
        defaultCss.add( getClass(), "/com/inet/application/googleanalytics/client/style/style.css" );
        spm.register( CombinedFileDescription.class, new CombinedFileDescription( RemoteGuiServerPlugin.APP_KEY, 107, "defaulttheme.css", defaultCss ) );

        if( spm.isPluginLoaded( "theme" ) ) {
            new Runnable() { // anonymous class to decouple class loading
                public void run() {
                    spm.register( ThemeResource.class, new ThemeResource( RemoteGuiServerPlugin.APP_KEY, GoogleAnalyticsServerPlugin.class.getResource( "/com/inet/application/googleanalytics/client/style/style.less" ) ) );
                }
            }.run();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void registerExtension( ServerPluginManager spm ) {
        // Registering extension ins Help
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void init( ServerPluginManager spm ) {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void reset() {
        // nothing
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void restart() {
        // nothing
    }

}
